<?php

// Set headers for API response
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

error_reporting(0);
include_once 'db.php';

// Read input value (optional)
$inputValue = $_POST['input'] ?? '';

try {
    // Query to fetch customer data
    $sql = "SELECT id, displayname FROM `customer` WHERE delete_status = 0  AND customertype IN (1, 2)";
    
    // Prepare the statement
    $stmt = $conn->prepare($sql);
    $delete_status = '0'; // Filter condition
    $stmt->bind_param("s", $delete_status);
    
    // Execute the query
    $stmt->execute();
    $result = $stmt->get_result();

    // Collect customer data
    $customer = [];
    while ($row = $result->fetch_assoc()) {
        $customer[] = [
            'id' => $row['id'],
            'displayname' => $row['displayname']
        ];
    }

    // Respond with the customer data in JSON format
    echo json_encode( $customer
    );
} catch (Exception $e) {
    // Handle errors and send a failure response
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to fetch data.',
        'error' => $e->getMessage()
    ]);
}

// Close the database conn
$conn->close();

?>
